<?php
require_once 'config.php';
require_once 'functions.php';

// 处理操作请求
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 重置超时时间
    set_time_limit(60);
    
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'open':
                $botId = trim($_POST['bot_id'] ?? '');
                $url = trim($_POST['url'] ?? '');
                $count = (int)($_POST['count'] ?? 0);
                $count = max(1, min($count, MAX_INSTANCES - count(getRunningInstances())));
                
                if (!empty($botId) && $count > 0) {
                    $result = openBrowsers($botId, $count, $url);
                    addLog("尝试打开 {$count} 个采集机器人（BotId: {$botId}）：" . ($result['success'] ? '成功' : $result['error']));
                } else {
                    $error = "请输入有效的BotId和数量（1-{$count}）";
                }
                break;
                
            case 'close':
                $instanceId = $_POST['instance_id'] ?? '';
                if ($instanceId) {
                    $success = closeBrowser($instanceId);
                    addLog("尝试关闭实例 {$instanceId}：" . ($success ? '成功' : '失败'));
                }
                break;
                
            case 'close_all':
                $success = closeAllBrowsers();
                addLog("尝试关闭所有实例：" . ($success ? '成功' : '失败'));
                break;
                
            case 'update_extension':
                $content = $_POST['extension_content'] ?? '';
                if (!empty($content)) {
                    file_put_contents(EXTENSION_PATH . '\content.js', $content);
                    $instances = getRunningInstances();
                    $updated = 0;
                    foreach ($instances as $instance) {
                        if (sendReloadCommand("ws://127.0.0.1:{$instance['port']}/devtools/browser")) {
                            $updated++;
                        }
                    }
                    addLog("更新插件并尝试刷新 {$updated}/" . count($instances) . " 个实例");
                    $successMsg = "插件已更新，正在刷新 {$updated} 个实例";
                }
                break;
        }
    }
}

// 获取当前运行的实例列表
$instances = getRunningInstances();
// 获取插件内容
$extensionContent = file_get_contents(EXTENSION_PATH . '\content.js');
?>

<!DOCTYPE html>
<html>
<head>
    <title>机器人控制中心</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
        .container { max-width: 1200px; margin: 0 auto; }
        .section { background: #f9f9f9; padding: 20px; margin-bottom: 20px; border-radius: 8px; }
        h1, h2 { color: #333; }
        .form-group { margin: 15px 0; }
        label { display: inline-block; width: 120px; vertical-align: top; }
        input[type="text"], input[type="number"], textarea { 
            padding: 8px; width: 300px; border: 1px solid #ddd; border-radius: 4px; 
        }
        textarea { height: 200px; width: 600px; }
        button { 
            padding: 10px 20px; background: #4CAF50; color: white; border: none; 
            border-radius: 4px; cursor: pointer; margin-right: 10px;
        }
        button:hover { background: #45a049; }
        button.close-btn { background: #f44336; }
        button.close-btn:hover { background: #d32f2f; }
        .instances { margin-top: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { 
            border: 1px solid #ddd; padding: 12px; text-align: left; 
        }
        th { background: #f2f2f2; }
        tr:hover { background: #f5f5f5; }
        .error { color: #dc3545; padding: 10px; background: #f8d7da; border-radius: 4px; }
        .success { color: #28a745; padding: 10px; background: #d4edda; border-radius: 4px; }
        .log { 
            margin-top: 20px; padding: 15px; background: #f8f9fa; 
            border-radius: 4px; max-height: 300px; overflow-y: auto;
            font-family: monospace; font-size: 0.9em;
        }
        .status { font-size: 0.9em; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <h1>机器人控制中心</h1>
        
        <!-- 打开浏览器表单 -->
        <div class="section">
            <h2>打开机器人实例</h2>
            <form method="post">
                <input type="hidden" name="action" value="open">
                <div class="form-group">
                    <label>机器人BotId：</label>
                    <input type="text" name="bot_id" placeholder="输入BotId（如2025001）" required>
                </div>
                <div class="form-group">
                    <label>Url</label>
                    <input type="text" name="url" value="https://ag.hga035.com/" placeholder="输入Url（如https://ag.hga035.com/）" required>
                </div>
                <div class="form-group">
                    <label>打开数量：</label>
                    <input type="number" name="count" min="1" 
                        max="1" 
                        value="1" required>
                    <span class="status">（当前还可打开：<?php echo MAX_INSTANCES - count($instances); ?> 个）</span>
                </div>
                <button type="submit">打开机器人</button>
            </form>
            <?php if (isset($error)) echo "<div class='error'>{$error}</div>"; ?>
            <?php if (isset($result) && $result['success']) echo "<div class='success'>成功打开 {$result['count']} 个浏览器</div>"; ?>
        </div>

        <!-- 运行中实例列表 -->
        <div class="section instances">
            <h2>当前运行的机器人实例（共 <?php echo count($instances); ?> 个）</h2>
            <?php if (count($instances) > 0): ?>
                <table>
                    <tr>
                        <th>ID</th>
                        <th>机器人BotId</th>
                        <th>URL</th>
                        <th>端口</th>
                        <th>启动时间</th>
                        <th>操作</th>
                    </tr>
                    <?php foreach ($instances as $instance): ?>
                    <tr>
                        <td><?php echo $instance['id']; ?></td>
                        <td><?php echo $instance['botId']; ?></td>
                        <td><?php echo $instance['url']; ?></td>
                        <td><?php echo $instance['port']; ?></td>
                        <td><?php echo date('Y-m-d H:i:s', $instance['startTime']); ?></td>
                        <td>
                            <form method="post" onsubmit="return confirm('确定要关闭这个实例吗？');">
                                <input type="hidden" name="action" value="close">
                                <input type="hidden" name="instance_id" value="<?php echo $instance['id']; ?>">
                                <button type="submit" class="close-btn">关闭</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </table>

                <!-- 关闭所有按钮 -->
                <form method="post" onsubmit="return confirm('确定要关闭所有实例吗？');" style="margin-top: 10px;">
                    <input type="hidden" name="action" value="close_all">
                    <button type="submit" class="close-btn">关闭所有浏览器</button>
                </form>
            <?php else: ?>
                <p>暂无运行中的机器人实例</p>
            <?php endif; ?>
        </div>

        <!-- 插件管理 -->
        <div class="section">
            <h2>插件管理</h2>
            <form method="post">
                <input type="hidden" name="action" value="update_extension">
                <div class="form-group">
                    <label>插件代码：</label>
                    <textarea name="extension_content"><?php echo htmlspecialchars($extensionContent); ?></textarea>
                </div>
                <button type="submit">更新并重新加载插件</button>
                <?php if (isset($successMsg)) echo "<div class='success'>{$successMsg}</div>"; ?>
            </form>
        </div>

        <!-- 操作日志 -->
        <div class="section" style="display: none;">
            <h2>操作日志</h2>
            <div class="log">
                <?php //echo getLatestLogs(20); // 显示最近20条日志 ?>
            </div>
        </div>
    </div>
</body>
</html>
    