<?php
// 配置文件 - config.php

// Chrome安装路径（根据系统类型选择）
// 64位系统
define('CHROME_PATH', 'C:\Program Files\Google\Chrome\Application\chrome.exe');
// 32位系统请使用下面的路径
// define('CHROME_PATH', 'C:\Program Files (x86)\Google\Chrome\Application\chrome.exe');

// 项目基础路径
define('BASE_PATH', __DIR__);

// 用户数据目录（每个实例独立）
define('USER_DATA_BASE', BASE_PATH . '\user_data');

// 插件路径
define('EXTENSION_PATH', BASE_PATH . '\chrome_extension');

// 实例数据存储文件
define('INSTANCES_FILE', BASE_PATH . '\instances.json');

// 日志目录
define('LOG_DIR', BASE_PATH . '\logs');

// 最大实例数量限制
define('MAX_INSTANCES', 5);

// 端口范围设置
define('MIN_PORT', 9222);
define('MAX_PORT', 9300);

// 确保所有目录存在
foreach ([USER_DATA_BASE, EXTENSION_PATH, LOG_DIR] as $dir) {
    if (!is_dir($dir)) {
        mkdir($dir, 0777, true);
        chmod($dir, 0777);
    }
}

// 确保实例文件存在
if (!file_exists(INSTANCES_FILE)) {
    file_put_contents(INSTANCES_FILE, '[]');
    chmod(INSTANCES_FILE, 0777);
}
    